/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.screen.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.renyigesai.immortalers_delight.Config;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WeakWitherHealthOverlay {
    protected static int healthIconsOffset;
    private static final ResourceLocation HEALTH_ICONS_TEXTURE;
    static ResourceLocation PLAYER_HEALTH_ELEMENT;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new WeakWitherHealthOverlay());
    }

    @SubscribeEvent
    public void onRenderGuiOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)PLAYER_HEALTH_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                WeakWitherHealthOverlay.renderWeakWitherOverlay(gui, event.getGuiGraphics());
            }
        }
    }

    public static void renderWeakWitherOverlay(ForgeGui gui, GuiGraphics graphics) {
        boolean isPlayerEligibleForWeakWither;
        if (!Config.weakPoisonHealthOverlay) {
            return;
        }
        healthIconsOffset = gui.leftHeight;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        FoodData stats = player.m_36324_();
        int top = minecraft.m_91268_().m_85446_() - healthIconsOffset + 10;
        int left = minecraft.m_91268_().m_85445_() / 2 - 91;
        boolean bl = isPlayerEligibleForWeakWither = !player.m_21023_(MobEffects.f_19605_);
        if (player.m_21124_((MobEffect)ImmortalersDelightMobEffect.WEAK_WITHER.get()) != null && isPlayerEligibleForWeakWither) {
            WeakWitherHealthOverlay.drawWeakWitherOverlay((Player)player, minecraft, graphics, left, top);
        }
    }

    public static void drawWeakWitherOverlay(Player player, Minecraft minecraft, GuiGraphics graphics, int left, int top) {
        int ticks = minecraft.f_91065_.m_93079_();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        int health = Mth.m_14167_((float)player.m_21223_());
        float absorb = Mth.m_14167_((float)player.m_6103_());
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = (float)attrMaxHealth.m_22135_();
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = ticks % 25;
        }
        int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int comfortSheen = ticks % 50;
        int comfortHeartFrame = comfortSheen % 2;
        int[] textureWidth = new int[]{5, 9};
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEALTH_ICONS_TEXTURE);
        RenderSystem.enableBlend();
        int healthMaxSingleRow = Mth.m_14167_((float)(Math.min(healthMax, 20.0f) / 2.0f));
        int leftHeightOffset = (healthRows - 1) * rowHeight;
        for (int i = 0; i < healthMaxSingleRow; ++i) {
            float effectiveHealthOfBar;
            int column = i % 10;
            int x = left + column * 8;
            int y = top + leftHeightOffset;
            if (health <= 4) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            if ((effectiveHealthOfBar = (float)health / 2.0f - (float)i) >= 1.0f) {
                graphics.m_280218_(HEALTH_ICONS_TEXTURE, x, y, 9, 9, 9, 9);
                continue;
            }
            if ((double)effectiveHealthOfBar >= 0.5) {
                graphics.m_280218_(HEALTH_ICONS_TEXTURE, x, y, 18, 9, 9, 9);
                continue;
            }
            graphics.m_280218_(HEALTH_ICONS_TEXTURE, x, y, 0, 9, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    static {
        HEALTH_ICONS_TEXTURE = new ResourceLocation("immortalers_delight", "textures/gui/icons/weak_wither_icons.png");
        PLAYER_HEALTH_ELEMENT = new ResourceLocation("minecraft", "player_health");
    }
}

